<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('client_id')->unsigned()->index();
			$table->integer('transaction_type_id')->unsigned();
			$table->double('amount')->nullable();
			$table->tinyInteger('request_status')->default('0');
			$table->bigInteger('verified_by')->unsigned()->nullable();
			$table->timestamps();
			$table->bigInteger('client_bank_account_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}