<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientBankAccountTable extends Migration {

	public function up()
	{
		Schema::create('client_bank_account', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('client_id')->unsigned();
			$table->bigInteger('master_bank_id')->unsigned();
			$table->bigInteger('available_bank_group_id')->unsigned();
			$table->string('account_name', 299);
			$table->string('account_number', 299);
			$table->tinyInteger('status')->default('1');
			$table->tinyInteger('visibility_status')->default('1');
			$table->bigInteger('added_by')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('client_bank_account');
	}
}