<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('client_id')->unsigned()->nullable();
			$table->string('name', 299);
			$table->string('email', 299)->nullable();
			$table->string('user_name', 299)->unique()->nullable();
			$table->string('password', 299);
			$table->string('pin', 299)->nullable();
			$table->tinyInteger('status')->default('1');
			$table->tinyInteger('verification_status')->default('0');
			$table->string('profile_pic', 299)->nullable();
			$table->integer('security_question_id')->unsigned()->nullable();
			$table->string('security_question_answer', 299)->nullable();
			$table->bigInteger('role_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}