<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogsTable extends Migration {

	public function up()
	{
		Schema::create('blogs', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->tinyInteger('status')->default('1');
			$table->bigInteger('added_by')->unsigned();
			$table->bigInteger('client_id')->unsigned()->nullable();
			$table->string('slug', 299)->nullable();
			$table->text('title');
			$table->text('summery');
			$table->text('content');
			$table->string('featured_image', 299)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('blogs');
	}
}