<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMasterBanksTable extends Migration {

	public function up()
	{
		Schema::create('master_banks', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('bank_name', 299);
			$table->text('bank_link')->nullable();
			$table->tinyInteger('isvisible')->default('0');
			$table->text('alternative_link');
			$table->string('logo', 299)->nullable();
			$table->integer('order')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('master_banks');
	}
}