<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInterviewMettingsTable extends Migration {

	public function up()
	{
		Schema::create('interview_mettings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('added_by_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->integer('interview_id')->unsigned();
			$table->date('date');
			$table->string('time');
			$table->string('value');
			$table->string('status')->default('not-completed');
		});
	}

	public function down()
	{
		Schema::drop('interview_mettings');
	}
}