<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmpRequestsTable extends Migration {

	public function up()
	{
		Schema::create('emp_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('added_by_id')->unsigned();
			$table->integer('employee_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->date('date');
			$table->string('start_time');
			$table->string('end_time');
			$table->string('status');
		});
	}

	public function down()
	{
		Schema::drop('emp_requests');
	}
}