<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatesTable extends Migration {

	public function up()
	{
		Schema::create('rates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('added_by_id')->unsigned();
			$table->integer('employee_id')->unsigned();
			$table->integer('rate_factor_id')->unsigned();
			$table->integer('year');
			$table->integer('month');
			$table->double('value');
			$table->date('date');
		});
	}

	public function down()
	{
		Schema::drop('rates');
	}
}