<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id');
			$table->string('phonecode', 5)->nullable();
			$table->string('short_name', 255)->nullable();
			$table->string('show_phonecode', 255)->nullable();
			$table->string('flag', 255)->nullable();
			$table->enum('continent', array('africa', 'europe', 'asia', 'south_america'))->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}