<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTraineesTable extends Migration {

	public function up()
	{
		Schema::create('trainees', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('added_by_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('mobile');
			$table->string('email');
			$table->date('start_date');
			$table->date('end_date');
			$table->integer('duration');
			$table->string('duration_type');
			$table->string('status')->default('hold');
		});
	}

	public function down()
	{
		Schema::drop('trainees');
	}
}