<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('USERS', function(Blueprint $table) {
			$table->foreign('roleID')->references('id')->on('ROLES')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ROLES_RIGHTS', function(Blueprint $table) {
			$table->foreign('roleID')->references('id')->on('ROLES')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ROLES_RIGHTS', function(Blueprint $table) {
			$table->foreign('rightID')->references('id')->on('RIGHTS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('FRAMES', function(Blueprint $table) {
			$table->foreign('userID')->references('id')->on('USERS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('FRAMES', function(Blueprint $table) {
			$table->foreign('planID')->references('id')->on('PLANS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('COMMENTS', function(Blueprint $table) {
			$table->foreign('frameID')->references('id')->on('FRAMES')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('COMMENTS', function(Blueprint $table) {
			$table->foreign('contactID')->references('id')->on('CONTACTS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('USERS_CONTACTS', function(Blueprint $table) {
			$table->foreign('userID')->references('id')->on('USERS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('USERS_CONTACTS', function(Blueprint $table) {
			$table->foreign('CONTACTID')->references('id')->on('CONTACTS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('TAGS', function(Blueprint $table) {
			$table->foreign('contactID')->references('id')->on('CONTACTS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('TAGS', function(Blueprint $table) {
			$table->foreign('frameID')->references('id')->on('FRAMES')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('PLANS', function(Blueprint $table) {
			$table->foreign('planTypeId')->references('id')->on('PLAN_TYPE')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('FRAME_CONTENTS', function(Blueprint $table) {
			$table->foreign('frameID')->references('id')->on('FRAMES')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('FRAME_CONTENTS_COMMENTS', function(Blueprint $table) {
			$table->foreign('frameContentID')->references('id')->on('FRAME_CONTENTS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('FRAME_CONTENTS_COMMENTS', function(Blueprint $table) {
			$table->foreign('contactID')->references('id')->on('CONTACTS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('FRAME_CONTENTS_TAGS', function(Blueprint $table) {
			$table->foreign('frameContentID')->references('id')->on('FRAME_CONTENTS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('FRAME_CONTENTS_TAGS', function(Blueprint $table) {
			$table->foreign('contactID')->references('id')->on('CONTACTS')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('BIN', function(Blueprint $table) {
			$table->foreign('frameID')->references('id')->on('FRAMES')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ARCHIVES', function(Blueprint $table) {
			$table->foreign('frameID')->references('id')->on('FRAMES')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('USERS', function(Blueprint $table) {
			$table->dropForeign('USERS_roleID_foreign');
		});
		Schema::table('ROLES_RIGHTS', function(Blueprint $table) {
			$table->dropForeign('ROLES_RIGHTS_roleID_foreign');
		});
		Schema::table('ROLES_RIGHTS', function(Blueprint $table) {
			$table->dropForeign('ROLES_RIGHTS_rightID_foreign');
		});
		Schema::table('FRAMES', function(Blueprint $table) {
			$table->dropForeign('FRAMES_userID_foreign');
		});
		Schema::table('FRAMES', function(Blueprint $table) {
			$table->dropForeign('FRAMES_planID_foreign');
		});
		Schema::table('COMMENTS', function(Blueprint $table) {
			$table->dropForeign('COMMENTS_frameID_foreign');
		});
		Schema::table('COMMENTS', function(Blueprint $table) {
			$table->dropForeign('COMMENTS_contactID_foreign');
		});
		Schema::table('USERS_CONTACTS', function(Blueprint $table) {
			$table->dropForeign('USERS_CONTACTS_userID_foreign');
		});
		Schema::table('USERS_CONTACTS', function(Blueprint $table) {
			$table->dropForeign('USERS_CONTACTS_CONTACTID_foreign');
		});
		Schema::table('TAGS', function(Blueprint $table) {
			$table->dropForeign('TAGS_contactID_foreign');
		});
		Schema::table('TAGS', function(Blueprint $table) {
			$table->dropForeign('TAGS_frameID_foreign');
		});
		Schema::table('PLANS', function(Blueprint $table) {
			$table->dropForeign('PLANS_planTypeId_foreign');
		});
		Schema::table('FRAME_CONTENTS', function(Blueprint $table) {
			$table->dropForeign('FRAME_CONTENTS_frameID_foreign');
		});
		Schema::table('FRAME_CONTENTS_COMMENTS', function(Blueprint $table) {
			$table->dropForeign('FRAME_CONTENTS_COMMENTS_frameContentID_foreign');
		});
		Schema::table('FRAME_CONTENTS_COMMENTS', function(Blueprint $table) {
			$table->dropForeign('FRAME_CONTENTS_COMMENTS_contactID_foreign');
		});
		Schema::table('FRAME_CONTENTS_TAGS', function(Blueprint $table) {
			$table->dropForeign('FRAME_CONTENTS_TAGS_frameContentID_foreign');
		});
		Schema::table('FRAME_CONTENTS_TAGS', function(Blueprint $table) {
			$table->dropForeign('FRAME_CONTENTS_TAGS_contactID_foreign');
		});
		Schema::table('BIN', function(Blueprint $table) {
			$table->dropForeign('BIN_frameID_foreign');
		});
		Schema::table('ARCHIVES', function(Blueprint $table) {
			$table->dropForeign('ARCHIVES_frameID_foreign');
		});
	}
}