<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePLANSTable extends Migration {

	public function up()
	{
		Schema::create('PLANS', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('plan_title', array('all_go', 'lite'));
			$table->enum('storage_capacity', array('8', '16', '32', '64'));
			$table->integer('userID');
			$table->integer('planTypeId')->unsigned()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('PLANS');
	}
}