<?php

namespace User;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function profile()
    {
        return $this->hasOne('User');
    }

    public function blogs()
    {
        return $this->hasMany('Blog', 'user_id');
    }

    public function notifications()
    {
        return $this->hasMany('Notification', 'user_id');
    }

    public function comments()
    {
        return $this->hasMany('Comment', 'user_id');
    }

    public function surveys()
    {
        return $this->hasMany('Survey', 'user_id');
    }

    public function tests()
    {
        return $this->hasMany('Tests', 'user_id');
    }

    public function homeworks()
    {
        return $this->hasMany('Homework', 'user_id');
    }

    public function courses()
    {
        return $this->belongsToMany('CourseUser', 'user_id');
    }

}