<?php

namespace Course;

class Course extends Eloquent {

	protected $table = 'courses';
	public $timestamps = true;

	public function progress()
	{
		return $this->hasMany('Progress', 'course_id');
	}

	public function surveys()
	{
		return $this->hasMany('Survey', 'course_id');
	}

	public function tests()
	{
		return $this->hasMany('Tests', 'course_id');
	}

	public function homeworks()
	{
		return $this->hasMany('Homework', 'course_id');
	}

	public function lectures()
	{
		return $this->hasMany('Lecture', 'course_id');
	}

	public function students()
	{
		return $this->belongsToMany('CourseStudent', 'student_id');
	}

	public function users()
	{
		return $this->belongsToMany('CourseUser', 'user_id');
	}

	public function diploma()
	{
		return $this->belongsTo('Diploma', 'diploma_id');
	}

}