<?php

namespace Question;

class Question extends Eloquent {

	protected $table = 'questions';
	public $timestamps = true;

	public function test()
	{
		return $this->belongsTo('Tests', 'test_id');
	}

	public function questionType()
	{
		return $this->belongsTo('QuestionType', 'question_type_id');
	}

	public function answers()
	{
		return $this->hasMany('Answer', 'question_id');
	}

	public function student_answer()
	{
		return $this->hasOne('Answer', 'student_id');
	}

	public function options()
	{
		return $this->hasMany('Option', 'question_id');
	}

}