<?php

namespace Student;

class Student extends Eloquent {

	protected $table = 'students';
	public $timestamps = true;

	public function certificate()
	{
		return $this->belongsTo('Certificate', 'certificate_id');
	}

	public function profile()
	{
		return $this->hasOne('Profile', 'student_id');
	}

	public function studentFiles()
	{
		return $this->hasMany('Student_files', 'student_id');
	}

	public function answers()
	{
		return $this->hasMany('Answer', 'student_id');
	}

	public function surveyAnswers()
	{
		return $this->hasMany('Survey_answers', 'student_id');
	}

	public function progress()
	{
		return $this->hasMany('Progress', 'student_id');
	}

	public function comments()
	{
		return $this->hasMany('Comment', 'student_id');
	}

	public function notifications()
	{
		return $this->hasMany('Notification', 'student_id');
	}

	public function lectures()
	{
		return $this->belongsToMany('LectureStudent', 'student_id');
	}

	public function courses()
	{
		return $this->belongsToMany('CourseStudent', 'student_id');
	}

	public function homeworks()
	{
		return $this->belongsToMany('HomworkStudent', 'student_id');
	}

	public function tests()
	{
		return $this->belongsToMany('Student_tests', 'student_id');
	}

	public function surveys()
	{
		return $this->belongsToMany('Student_surveys', 'student_id');
	}

}