<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLecturesTable extends Migration {

	public function up()
	{
		Schema::create('lectures', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->integer('type');
			$table->string('title', 255);
			$table->string('desc', 255);
			$table->string('link', 255);
			$table->date('start_date');
			$table->date('end_date');
			$table->integer('course_id');
		});
	}

	public function down()
	{
		Schema::drop('lectures');
	}
}