<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChallengeElementsTable extends Migration {

	public function up()
	{
		Schema::create('challenge_elements', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('challenge_id')->unsigned()->nullable();
			$table->bigInteger('event_realization_id')->unsigned();
			$table->bigInteger('quiz_id')->unsigned();
			$table->bigInteger('activity_id')->unsigned();
			$table->integer('level');
			$table->string('description', 2048);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('challenge_elements');
	}
}