<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name', 128);
			$table->string('surname', 128);
			$table->string('nick', 128)->unique();
			$table->string('email', 256)->unique();
			$table->integer('birthyear');
			$table->integer('s1')->default('0');
			$table->integer('s2')->default('0');
			$table->integer('s3')->default('0');
			$table->integer('s4')->default('0');
			$table->integer('s5')->default('0');
			$table->integer('s6')->default('0');
			$table->integer('s7')->default('0');
			$table->integer('s8')->default('0');
			$table->integer('s1_period');
			$table->integer('s2_period');
			$table->integer('s3_period');
			$table->integer('s4_period');
			$table->integer('s5_period');
			$table->integer('s6_period');
			$table->integer('s7_period');
			$table->integer('s8_period');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}