<?php

namespace App\Models\Newletter;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Automatism extends Eloquent {

	protected $table = 'automatisms';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function groups()
	{
		return $this->belongsToMany('App\Models\Newletter\Group');
	}

	public function newletter()
	{
		return $this->belongsTo('App\Models\Newletter\Newsletter');
	}

	public function site()
	{
		return $this->belongsTo('App\Models\Newletter\Site');
	}

}