<?php

namespace App\Models\Newletter;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Newsletter extends Eloquent {

	protected $table = 'newsletters';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function site()
	{
		return $this->belongsTo('App\Models\Newletter\Site');
	}

	public function automatisms()
	{
		return $this->hasMany('App\Models\Newletter\Automatism');
	}

}