<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliedNewslettersTable extends Migration {

	public function up()
	{
		Schema::create('supplied_newsletters', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->text('editor_code');
			$table->text('html');
			$table->text('preview');
			$table->enum('state', array('enabled', 'disabled'));
		});
	}

	public function down()
	{
		Schema::drop('supplied_newsletters');
	}
}