<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->nullable()->index();
			$table->string('email', 255)->index();
			$table->string('password', 255);
			$table->string('avatar', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}