<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransportationsTable extends Migration {

	public function up()
	{
		Schema::create('transportations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('sub_dispatch_id')->unsigned();
			$table->string('name');
			$table->string('phone');
			$table->text('address');
			$table->string('email');
			$table->integer('payment_term_id');
			$table->double('freight');
			$table->string('gst_tin', 15);
			$table->string('driver_name');
			$table->string('driver_phone');
			$table->string('vehicle_no');
			$table->smallInteger('carrying_capacity');
			$table->integer('vehicle_type_id');
			$table->mediumInteger('quantity');
			$table->string('vehicle_tracking_url');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('transportations');
	}
}