<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('email', 'phone', 'city_id', 'address', 'profile_image');

    public function city()
    {
        return $this->belongsTo('City');
    }

    public function orders()
    {
        return $this->hasMany('App\Order');
    }

}