<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('email', 'phone', 'city_id', 'address', 'profile_image');

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function orders()
	{
		return $this->hasMany('App\Order');
	}

}