<?php

namespace App/jokes;

use Illuminate\Database\Eloquent\Model;

class Jokes extends Model 
{

    protected $table = 'joke_jokes';
    public $timestamps = true;

    public function category()
    {
        return $this->belongsTo('App/category\Category', 'categoryId');
    }

    public function joketype()
    {
        return $this->belongsTo('JokeType', 'typeId');
    }

    public function length()
    {
        return $this->hasOne('App/length\JokeLength', 'lengthId');
    }

    public function User()
    {
        return $this->hasOne('App/user\User', 'userId');
    }

}