<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEateriesTable extends Migration {

	public function up()
	{
		Schema::create('eateries', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->text('description');
			$table->string('logo')->nullable();
			$table->boolean('delivery_status')->default(false);
			$table->integer('category_id')->unsigned();
			$table->integer('contact_info_id')->unsigned();
			$table->integer('rating_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('schedule_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('eateries');
	}
}