<?php

namespace Akt;

use Illuminate\Database\Eloquent\Model;

class Akt extends Model 
{

    protected $table = 'akts';
    public $timestamps = true;
    protected $fillable = array('pokazanie');

    public function forArendator()
    {
        return $this->belongsToMany('Arendator', 'arendators_id');
    }

    public function ForZdanie()
    {
        return $this->belongsToMany('Zdanie', 'zdanies_id');
    }

    public function ForDate()
    {
        return $this->hasOne('Datepok', 'datepoks_id');
    }

    public function ForSchetchik()
    {
        return $this->belongsToMany('Schetchik', 'schetchiks_id');
    }

}