<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tarifs', function(Blueprint $table) {
			$table->foreign('datepoks_id')->references('id')->on('datepoks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('zdanies', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('zdanies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('akts', function(Blueprint $table) {
			$table->foreign('datepoks_id')->references('id')->on('datepoks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('akts', function(Blueprint $table) {
			$table->foreign('arendators_id')->references('id')->on('arendators')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('akts', function(Blueprint $table) {
			$table->foreign('office_id')->references('id')->on('office')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('akts', function(Blueprint $table) {
			$table->foreign('schetchiks_id')->references('id')->on('schetchiks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('akts_id')->references('id')->on('akts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('tarifs_id')->references('id')->on('tarifs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('office', function(Blueprint $table) {
			$table->foreign('zdanies_id')->references('id')->on('zdanies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tarifs', function(Blueprint $table) {
			$table->dropForeign('tarifs_datepoks_id_foreign');
		});
		Schema::table('zdanies', function(Blueprint $table) {
			$table->dropForeign('zdanies_parent_id_foreign');
		});
		Schema::table('akts', function(Blueprint $table) {
			$table->dropForeign('akts_datepoks_id_foreign');
		});
		Schema::table('akts', function(Blueprint $table) {
			$table->dropForeign('akts_arendators_id_foreign');
		});
		Schema::table('akts', function(Blueprint $table) {
			$table->dropForeign('akts_office_id_foreign');
		});
		Schema::table('akts', function(Blueprint $table) {
			$table->dropForeign('akts_schetchiks_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_akts_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_tarifs_id_foreign');
		});
		Schema::table('office', function(Blueprint $table) {
			$table->dropForeign('office_zdanies_id_foreign');
		});
	}
}