<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id');
			$table->integer('country_id');
			$table->string('first_name', 45);
			$table->string('last_name', 45);
			$table->string('address1', 255);
			$table->string('address2', 255);
			$table->string('country', 255);
			$table->string('city', 255);
			$table->integer('postal_code')->default('50');
			$table->string('phone', 50);
			$table->string('mobile_phone', 50);
			$table->text('comment');
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}