<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id');
			$table->integer('status_id');
			$table->string('carrier_id');
			$table->integer('shipping_address_id');
			$table->string('billing_address_id');
			$table->integer('currency_id');
			$table->text('comment');
			$table->string('shipping_no', 255);
			$table->date('invoice_date');
			$table->datetime('delivery_date');
			$table->text('shipping_address');
			$table->text('billing_address');
			$table->decimal('total_discount', 13,6);
			$table->decimal('total_discount_tax');
			$table->decimal('total_shipping');
			$table->decimal('total_shipping_tax');
			$table->decimal('total_decimal');
			$table->decimal('total_tax');
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}