<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tips', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('images')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('images')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('parent_question_id')->references('id')->on('questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('images')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sub_question_logic', function(Blueprint $table) {
			$table->foreign('sub_question_id')->references('id')->on('questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answer_logic', function(Blueprint $table) {
			$table->foreign('logic_id')->references('id')->on('sub_question_logic')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answer_logic', function(Blueprint $table) {
			$table->foreign('answer_id')->references('id')->on('answers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('refferal_pathway', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('images')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('refferal_pathway', function(Blueprint $table) {
			$table->foreign('parent_pathway')->references('id')->on('refferal_pathway')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('tips', function(Blueprint $table) {
			$table->dropForeign('tips_image_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_category_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_image_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_parent_question_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_question_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_image_id_foreign');
		});
		Schema::table('sub_question_logic', function(Blueprint $table) {
			$table->dropForeign('sub_question_logic_sub_question_id_foreign');
		});
		Schema::table('answer_logic', function(Blueprint $table) {
			$table->dropForeign('answer_logic_logic_id_foreign');
		});
		Schema::table('answer_logic', function(Blueprint $table) {
			$table->dropForeign('answer_logic_answer_id_foreign');
		});
		Schema::table('refferal_pathway', function(Blueprint $table) {
			$table->dropForeign('refferal_pathway_image_id_foreign');
		});
		Schema::table('refferal_pathway', function(Blueprint $table) {
			$table->dropForeign('refferal_pathway_parent_pathway_foreign');
		});
	}
}