<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('language_key', 299);
			$table->integer('category_id')->unsigned();
			$table->enum('question_type', array('date', 'Radio', 'checkbox', 'TextInput'));
			$table->integer('image_id')->unsigned();
			$table->enum('module', array('SC', 'VQ'));
			$table->integer('parent_question_id')->unsigned()->nullable()->default('0');
			$table->longText('question_en')->nullable();
			$table->longText('question_ind')->nullable();
			$table->longText('question_malay')->nullable();
			$table->longText('question_thai')->nullable();
			$table->longText('question_urdu')->nullable();
			$table->longText('question_burmese')->nullable();
			$table->longText('question_rohingya')->nullable();
			$table->longText('question_dari')->nullable();
			$table->longText('question_somali')->nullable();
			$table->longText('question_arabic')->nullable();
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}