<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTipsTable extends Migration {

	public function up()
	{
		Schema::create('tips', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title_language_key', 299);
			$table->string('desc_language_key', 299);
			$table->integer('order');
			$table->integer('image_id')->unsigned();
			$table->text('title_en')->nullable();
			$table->text('title_ind')->nullable();
			$table->text('title_malay')->nullable();
			$table->text('title_thai')->nullable();
			$table->longText('desc_en')->nullable();
			$table->longText('desc_ind')->nullable();
			$table->longText('desc_malay')->nullable();
			$table->longText('desc_thai')->nullable();
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tips');
	}
}