<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExperimentReportTable extends Migration {

	public function up()
	{
		Schema::create('experiment_report', function(Blueprint $table) {
			$table->increments('id');
			$table->smallInteger('student_id')->unsigned();
			$table->string('name', 255);
			$table->string('purpose', 255);
			$table->string('content', 255);
			$table->string('result', 255);
			$table->smallInteger('photo_id')->unsigned();
			$table->smallInteger('article_id')->unsigned();
			$table->smallInteger('video_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('experiment_report');
	}
}