<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentTable extends Migration {

	public function up()
	{
		Schema::create('student', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 10);
			$table->smallInteger('age')->unsigned();
			$table->string('choose_course');
			$table->string('grade', 10);
			$table->string('class', 10);
			$table->string('major', 10);
			$table->string('study_num', 15);
			$table->string('email', 20);
			$table->string('mobile', 15);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('student');
	}
}