<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('article_external')->nullable()->default('null');
			$table->string('name');
			$table->string('description')->nullable();
			$table->string('image')->nullable();
			$table->decimal('price_initial')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}