<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('item_has_tags', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_has_tags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('item_tags')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shop_offers', function(Blueprint $table) {
			$table->foreign('shop_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shop_offers', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('shop_id')->references('id')->on('shops')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('shop_offers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shop_has_users', function(Blueprint $table) {
			$table->foreign('shop_id')->references('id')->on('shops')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shop_has_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('item_has_tags', function(Blueprint $table) {
			$table->dropForeign('item_has_tags_item_id_foreign');
		});
		Schema::table('item_has_tags', function(Blueprint $table) {
			$table->dropForeign('item_has_tags_tag_id_foreign');
		});
		Schema::table('shop_offers', function(Blueprint $table) {
			$table->dropForeign('shop_offers_shop_id_foreign');
		});
		Schema::table('shop_offers', function(Blueprint $table) {
			$table->dropForeign('shop_offers_item_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_shop_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_offer_id_foreign');
		});
		Schema::table('shop_has_users', function(Blueprint $table) {
			$table->dropForeign('shop_has_users_shop_id_foreign');
		});
		Schema::table('shop_has_users', function(Blueprint $table) {
			$table->dropForeign('shop_has_users_user_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_order_id_foreign');
		});
	}
}