<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->text('description');
			$table->string('short_description', 255);
			$table->decimal('price', 10,2);
			$table->integer('type_id')->unsigned();
			$table->integer('model_id')->unsigned();
			$table->integer('visibility_id')->unsigned();
			$table->integer('tax_group_id');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}