<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderDetailsTable extends Migration {

	public function up()
	{
		Schema::create('order_details', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->bigInteger('quantity');
			$table->bigInteger('unit_price');
			$table->string('category', 255);
			$table->string('model', 255)->nullable();
			$table->string('brand', 255)->nullable();
			$table->integer('product_id')->unsigned()->nullable();
			$table->integer('combination_id')->unsigned()->nullable();
			$table->integer('order_id')->unsigned();
			$table->string('combination_value')->nullable();
			$table->string('combination_attribute')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order_details');
	}
}