<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamp('timestamps');
			$table->string('company_name', 255);
			$table->string('company_address');
			$table->string('company_tel', 255);
			$table->string('customer_firstname', 255);
			$table->string('customer_lastname', 255);
			$table->string('customer_address', 255);
			$table->string('customer_email', 255);
			$table->string('customer_tel');
			$table->integer('customer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}