<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Appointment extends Model 
{

    protected $table = 'appointments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function patient()
    {
        return $this->belongsTo('Patient');
    }

    public function supplier()
    {
        return $this->belongsTo('Patient');
    }

    public function service()
    {
        return $this->belongsTo('ServiceSite', 'service_site_id');
    }

    public function medicalFile()
    {
        return $this->belongsTo('MedicalFile');
    }

    public function patientReminders()
    {
        return $this->hasMany('PatientReminder');
    }

    public function medicalFileSharingRequest()
    {
        return $this->hasOne('MedicalFileSharingrequest');
    }

}