<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MedicalFile extends Model 
{

    protected $table = 'medical_files';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function patient()
    {
        return $this->belongsTo('Patient');
    }

    public function creator()
    {
        return $this->morphTo();
    }

    public function medicalFileShares()
    {
        return $this->hasMany('MedicalFileShare');
    }

    public function appointment()
    {
        return $this->hasOne('Appointment');
    }

}