<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MedicalFileShare extends Model 
{

    protected $table = 'medical_file_shares';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function medicalFile()
    {
        return $this->belongsTo('MedicalFile');
    }

    public function recipient()
    {
        return $this->morphTo();
    }

    public function sender()
    {
        return $this->morphTo();
    }

}