<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MedicalFileSharingrequest extends Model 
{

    protected $table = 'medical_file_sharing_requests';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function patient()
    {
        return $this->belongsTo('Patient');
    }

    public function appointment()
    {
        return $this->belongsTo('Appointment');
    }

    public function supplier()
    {
        return $this->belongsTo('Supplier');
    }

}