<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Patient extends Model 
{

    protected $table = 'patients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function medicalProfile()
    {
        return $this->hasOne('MedicalProfile');
    }

    public function medicalFiles()
    {
        return $this->hasMany('MedicalFile');
    }

    public function createdMedicalFiles()
    {
        return $this->morphMany('MedicalFile', 'creator');
    }

    public function sharedMedicalFiles()
    {
        return $this->morphMany('MedicalFileShare', 'sender');
    }

    public function receivedMedicalFiles()
    {
        return $this->morphMany('MedicalFileShare', 'recipient');
    }

    public function referrals()
    {
        return $this->hasMany('Patient', 'referred_by_id');
    }

    public function referrer()
    {
        return $this->belongsTo('Patient', 'referred_by_id');
    }

    public function appointments()
    {
        return $this->hasMany('Appointment');
    }

    public function patientReminders()
    {
        return $this->hasMany('PatientReminder');
    }

    public function medicalFileSharingRequests()
    {
        return $this->hasMany('MedicalFileSharingrequest');
    }

}