<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMedicalProfilesTable extends Migration {

	public function up()
	{
		Schema::create('medical_profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('patient_id')->unsigned();
			$table->string('blood_type')->nullable();
			$table->double('weight')->nullable();
			$table->integer('height')->nullable();
			$table->enum('gender', array('male', 'female', 'other'))->nullable();
			$table->boolean('currently_pregnant')->default(false);
			$table->boolean('has_previous_pathologies')->default(false);
			$table->text('previous_pathologies')->nullable();
			$table->boolean('has_current_pathologies')->default(false);
			$table->text('current_pathologies');
			$table->boolean('has_previous_therapies')->default(false);
			$table->text('previopus_therapies')->nullable();
			$table->boolean('has_current_therapies')->default(false);
			$table->text('current_therapies')->nullable();
			$table->boolean('has_previous_surgeries')->default(false);
			$table->text('previous_surgeries')->nullable();
			$table->boolean('has_allergies')->default(false);
			$table->text('allergies')->nullable();
			$table->longText('notes')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('medical_profiles');
	}
}