<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email')->unique();
			$table->string('password');
			$table->date('dob')->nullable();
			$table->string('image')->nullable();
			$table->string('pob_city')->nullable();
			$table->string('pob_province')->nullable();
			$table->string('tax_code')->nullable();
			$table->string('mobile_number')->nullable();
			$table->string('google_auth_id')->nullable();
			$table->string('google_auth_token');
			$table->string('facebook_auth_id')->nullable();
			$table->string('facebook_auth_token')->nullable();
			$table->string('referal_code')->index();
			$table->bigInteger('referred_by_id')->unsigned()->nullable()->index();
			$table->integer('points_to_referrer')->unsigned()->default('0');
			$table->string('invoice_name')->nullable();
			$table->string('invoice_surname')->nullable();
			$table->string('invoice_email')->nullable();
			$table->string('invoice_vat')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}