<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliersTable extends Migration {

	public function up()
	{
		Schema::create('suppliers', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('doctor', 'lab', 'omnyacare'));
			$table->integer('subscription_cost')->unsigned();
			$table->integer('booking_fee_percentage')->unsigned();
			$table->integer('uploads_cap')->unsigned();
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('image')->nullable();
			$table->string('specialisation')->nullable();
			$table->string('company_name')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('suppliers');
	}
}